<?php

class AnticWP_License {
    private $api_url = 'https://www.anticwp.com/wp-json/anticad/v1/verify'; 

    public function is_valid() {
        return get_option( 'anticwp_license_status' ) === 'active';
    }

    public function get_status_label() {
        $status = get_option( 'anticwp_license_status', 'inactive' );
        if ( $status === 'active' ) return '<span class="status-badge active">' . __( 'ACTIVE', 'anticwp' ) . '</span>';
        if ( $status === 'expired' ) return '<span class="status-badge expired">' . __( 'EXPIRED', 'anticwp' ) . '</span>';
        if ( $status === 'invalid' ) return '<span class="status-badge invalid">' . __( 'INVALID', 'anticwp' ) . '</span>';
        return '<span class="status-badge">' . __( 'INACTIVE', 'anticwp' ) . '</span>';
    }

    public function activate( $key ) {
        return $this->perform_remote_check( $key );
    }

    public function check_license_status() {
        $key = get_option( 'anticwp_license_key' );
        if ( empty( $key ) ) return;
        $this->perform_remote_check( $key );
    }

    private function perform_remote_check( $key ) {
        $domain = $_SERVER['HTTP_HOST'];
        $request_url = $this->api_url;
        if ( get_option( 'anticwp_cache_compatible' ) === 'yes' ) {
            $request_url = add_query_arg( 't', time(), $request_url );
        }

        $response = wp_remote_post( $request_url, array(
            'body' => array( 'license_key' => $key, 'domain' => $domain ),
            'timeout' => 10,
            'sslverify' => false 
        ));

        if ( is_wp_error( $response ) ) return false; 

        $code = wp_remote_retrieve_response_code( $response );
        $body = wp_remote_retrieve_body( $response );
        $data = json_decode( $body, true );

        if ( $code === 200 && isset( $data['success'] ) && $data['success'] === true ) {
            update_option( 'anticwp_license_key', sanitize_text_field( $key ) );
            update_option( 'anticwp_license_status', 'active' );
            if(isset($data['data']['expires_at'])) {
                update_option( 'anticwp_license_expiry', $data['data']['expires_at'] );
            }
            return true;
        } else {
            $status = 'invalid';
            if ( isset($data['code']) && ($data['code'] === 'expired' || $data['code'] === 'domain_expired') ) {
                $status = 'expired';
            }
            update_option( 'anticwp_license_status', $status );
            return false;
        }
    }
}