<?php

class AnticWP_Orders {
    private $license;

    public function __construct( $license ) {
        $this->license = $license;
        if ( ! $this->license->is_valid() || get_option( 'anticwp_is_enabled', 'yes' ) !== 'yes' ) {
            return;
        }

        add_action( 'load-post.php', array( $this, 'process_order_fix_on_load' ) );
        add_action( 'load-woocommerce_page_wc-orders', array( $this, 'process_order_fix_on_load' ) ); 
        add_action( 'add_meta_boxes', array( $this, 'add_order_meta_box' ) );
        add_filter( 'manage_edit-shop_order_columns', array( $this, 'add_order_columns' ) );
        add_action( 'manage_shop_order_posts_custom_column', array( $this, 'render_order_columns' ), 10, 2 );
        add_filter( 'manage_woocommerce_page_wc-orders_columns', array( $this, 'add_order_columns' ) );
        add_action( 'manage_woocommerce_page_wc-orders_custom_column', array( $this, 'render_order_columns' ), 10, 2 );
    }

    public function process_order_fix_on_load() {
        $screen = get_current_screen();
        if ( ! $screen ) return;
        $order_id = 0;
        if ( isset($_GET['post']) ) $order_id = intval($_GET['post']); 
        elseif ( isset($_GET['id']) ) $order_id = intval($_GET['id']); 

        if ( $order_id > 0 ) {
            $order = wc_get_order( $order_id );
            if ( ! $order ) return;
            $fees = $order->get_fees();
            $negative_fee_id = 0;
            $deduction_amount = 0;

            foreach ( $fees as $fee_id => $fee ) {
                if ( floatval( $fee->get_total() ) < 0 ) {
                    $negative_fee_id = $fee_id;
                    $deduction_amount = abs( floatval( $fee->get_total() ) );
                    break;
                }
            }

            if ( $negative_fee_id > 0 ) {
                $paid_online = floatval( $order->get_total() );
                $order->update_meta_data( '_anticwp_pay_later', $deduction_amount );
                $order->update_meta_data( '_anticwp_paid_online', $paid_online );
                wc_delete_order_item( $negative_fee_id );
                $order->calculate_totals();
                $order->add_order_note( __( 'AnticWP: Total automatically recalculated during viewing.', 'anticwp' ) );
                $order->save();

                if ( ! isset( $_GET['anticwp_fixed'] ) ) {
                    wp_redirect( add_query_arg( 'anticwp_fixed', '1', $_SERVER['REQUEST_URI'] ) );
                    exit;
                }
            }
        }
    }

    public function add_order_meta_box() {
        $screens = array( 'shop_order', 'woocommerce_page_wc-orders' );
        foreach ( $screens as $s ) add_meta_box( 'anticwp_breakdown', __( 'AnticWP - Payment Analysis', 'anticwp' ), array( $this, 'render_meta_box' ), $s, 'side', 'high' );
    }

    public function render_meta_box( $post_or_order ) {
        $order = ( $post_or_order instanceof WC_Order ) ? $post_or_order : wc_get_order( $post_or_order->ID );
        if(!$order) return;
        $paid = $order->get_meta( '_anticwp_paid_online' );
        $due = $order->get_meta( '_anticwp_pay_later' );

        if ( $due ) {
            echo '<div style="padding:10px 0;">';
            echo '<div style="display:flex; justify-content:space-between; margin-bottom:5px;"><strong>' . __( 'Total Products+:', 'anticwp' ) . '</strong><span>' . wc_price( $order->get_total() ) . '</span></div>';
            echo '<div style="display:flex; justify-content:space-between; margin-bottom:5px; color:#46b450;"><strong>' . __( 'Paid (Online):', 'anticwp' ) . '</strong><span>' . wc_price( $paid ) . '</span></div>';
            echo '<div style="background:#fdf2f2; border:1px solid #fc8181; padding:10px; border-radius:4px; margin-top:10px;">';
            echo '<strong style="color:#c53030; display:block; font-size:12px;">' . __( 'COMPENSATION AMOUNT (Courier):', 'anticwp' ) . '</strong>';
            echo '<span style="font-size:18px; font-weight:bold; color:#c53030;">' . wc_price( $due ) . '</span>';
            echo '</div></div>';
        } else {
            echo '<p style="color:#777;">' . __( 'Full Repayment (or not recalculated yet).', 'anticwp' ) . '</p>';
        }
    }

    public function add_order_columns($cols) {
        $new = []; 
        foreach($cols as $k=>$v){ 
            $new[$k]=$v; 
            if($k==='order_total') $new['anticwp_due']= __( 'Cash On Delivery', 'anticwp' ); 
        } 
        return $new;
    }

    public function render_order_columns($col, $pid) {
        if($col==='anticwp_due'){
            $ord=wc_get_order($pid);
            $due = $ord->get_meta('_anticwp_pay_later');
            if($due) echo '<strong style="color:#d63638;">'.wc_price($due).'</strong>';
            else echo '-';
        }
    }
}